{**
* 2007-2019 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License 3.0 (AFL-3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* https://opensource.org/licenses/AFL-3.0
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author PrestaShop SA <contact@prestashop.com>
  * @copyright 2007-2017 PrestaShop SA
  * @license https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
  * International Registered Trademark & Property of PrestaShop SA
  *}
  {extends file=$layout}

  {block name='head_seo' prepend}
  <link rel="canonical" href="{$product.canonical_url}">
  {/block}

  {block name='head' append}
  <meta property="og:type" content="product">
  <meta property="og:url" content="{$urls.current_url}">
  <meta property="og:title" content="{$page.meta.title}">
  <meta property="og:site_name" content="{$shop.name}">
  <meta property="og:description" content="{$page.meta.description}">
  <meta property="og:image" content="{$product.cover.large.url}">
  {if $product.show_price}
  <meta property="product:pretax_price:amount" content="{$product.price_tax_exc}">
  <meta property="product:pretax_price:currency" content="{$currency.iso_code}">
  <meta property="product:price:amount" content="{$product.price_amount}">
  <meta property="product:price:currency" content="{$currency.iso_code}">
  {/if}
  {if isset($product.weight) && ($product.weight != 0)}
  <meta property="product:weight:value" content="{$product.weight}">
  <meta property="product:weight:units" content="{$product.weight_unit}">
  {/if}
  {/block}

  {block name='content'}

  <section id="main" itemscope itemtype="https://schema.org/Product">
    <meta itemprop="url" content="{$product.url}">
    {if $product.ean13}
    <meta itemprop="gtin13" content="{$product.ean13}">
    {elseif $product.supplier_reference}
    <meta itemprop="gtin" content="{$product.supplier_reference}">

    {else}
    {* <meta itemprop="identifier_exists" content="false"> *}
    {/if}
    <meta itemprop="mpn" content="{$product.supplier_reference}">

      <div class="col-lg-6 col-image">
        {block name='page_content_container'}
        <section class="col-image-inside">


          {block name='product_additional_info'}
          {include file='catalog/_partials/product-additional-info.tpl'}
          {/block}



        </section>
        {/block}
      </div>
      {block name='page_header_container'}
      {block name='page_header'}
      <h1 class="h1 product-title" itemprop="name">{block name='page_title'}{$product.name}{/block}</h1>
      {/block}
      {/block}
      {assign var=tags value=Tag::getProductTags($product->id)}
      {assign var=id_lang value=Context::getContext()->language->id}
      {assign var=product_tags value=$tags[$id_lang] }
      <!-- <div class="col-lg-6 col-content">
        <div class="col-content-inside">


          {if isset($nbComments) && $nbComments > 0}
          <div class="comments_note" itemprop="aggregateRating" itemscope itemtype="http://schema.org/AggregateRating">
            <div class="star_content clearfix">
              {section name="i" start=0 loop=5 step=1}
              {if $averageTotal le $smarty.section.i.index}
              <div class="star"></div>
              {else}
              <div class="star star_on"></div>
              {/if}
              {/section}
              <span itemprop="ratingValue" class="hidden">{$averageTotal}</span>
              <span class="nb-comments"><span itemprop="reviewCount">{l s='%s'|sprintf:$nbComments
                  mod='productcomments'}</span> {l s='Review(s)'}</span>
            </div>
          </div>
          {/if}



        </div>

      </div> -->

<div class="" style="width: 41%;display:inline-block;vertical-align:top;" >
  {block name='page_content'}
  {block name='product_flags'}
  <ul class="product-flags">
    {foreach from=$product.flags item=flag}
    <li class="product-flag {$flag.type}">{$flag.label}</li>
    {/foreach}
  </ul>
  {/block}

  {block name='product_cover_thumbnails'}
  {include file='catalog/_partials/product-cover-thumbnails.tpl'}
  {/block}

  {/block}
</div>
<div class="" style="width: 38%;display:inline-block;vertical-align:top;">
  {block name='product_description_short'}
  <div id="product-description-short-{$product.id}" сlass="product-short-desc" itemprop="description">
    {$product.description_short nofilter}</div>
  {/block}
  {block name='cg-flags'}
  {include file='_partials/cg-product-flags-ficheprod.tpl'}
  {/block}
  <div class="cardlist l3 m3 s3 product-info">
    {block name='product_reference'}
      {if isset($product.reference_to_display)}
        <div class="product-reference">
          <label class="label">{l s='Reference' d='Shop.Theme.Catalog'} </label>
          <span itemprop="sku">{$product.reference_to_display}</span>
        </div>
      {/if}
    {/block}
    <div>dispo</div>
    <div>marque</div>
  </div>
</div>
<div class="" style="position:sticky;top:50px;width:20%;display:inline-block;vertical-align:top;">
  {block name='product_buy'}
  <form action="{$urls.pages.cart}" method="post" id="add-to-cart-or-refresh">
    <input type="hidden" name="token" value="{$static_token}">
    <input type="hidden" name="id_product" value="{$product.id}" id="product_page_product_id">
    <input type="hidden" name="id_customization" value="{$product.id_customization}"
      id="product_customization_id">

    {block name='product_variants'}
    {include file='catalog/_partials/product-variants.tpl'}
    {/block}

    {block name='product_pack'}
    {if $packItems}
    <section class="product-pack">
      <h3 class="h4">{l s='This pack contains' d='Shop.Theme.Catalog'}</h3>
      {foreach from=$packItems item="product_pack"}
      {block name='product_miniature'}
      {include file='catalog/_partials/miniatures/pack-product.tpl' product=$product_pack}
      {/block}
      {/foreach}
    </section>
    {/if}
    {/block}

    {block name='product_discounts'}
    {include file='catalog/_partials/product-discounts.tpl'}
    {/block}

    {block name='product_prices'}
    {include file='catalog/_partials/product-prices.tpl'}
    {/block}

    {block name='product_out_of_stock'}
    <div class="product-out-of-stock">
      {hook h='actionProductOutOfStock' product=$product}
    </div>
    {/block}

    {block name='product_refresh'}
    <input class="product-refresh ps-hidden-by-js" name="refresh" type="submit"
      value="{l s='Refresh' d='Shop.Theme.Actions'}">
    {/block}
  </form>
  {/block}
  {if $product.is_customizable && count($product.customizations.fields)}
  {block name='product_customization'}
  {include file="catalog/_partials/product-customization.tpl" customizations=$product.customizations}
  {/block}
  {/if}
</div>
<div class="" style="background-color:#ddd;height:800px;width:70%;display:inline-block;vertical-align:top;">
</div>
    {block name='product_tabs'}
    <div style="position:relative;display:none;" id="prodscroll">

      <div id="prodscrollcontent">
        <!--          Presentation-->
        {if $product.description}
        <div class="card prodtext">
          <h2 id="presentation">Présentation : {$product.name}</h2>
          {$product.description nofilter}
        </div>
        {/if}
        <!--          Spécifications-->
        {if $product.features}
        <div class="card">
          <h2 id="specifications">Spécifications : {$product.name}</h2>
          {include file='catalog/_partials/product-details.tpl'}
        </div>
        {/if}
        {* spec Feature group *}

        {block name='product_footer'}
        {hook h='displayFooterProduct' product=$product category=$category}
        {/block}

        <!--          Documentation-->
        {if $product.attachments}
        <div class="card">
          <h2 id="documentation">Documentation : {$product.name}</h2>
          <div class="accessoires-list gapcardlist l3 m2 s1">
            {foreach from=$product.attachments item=attachment}
            <div class="attachment">

              <h3><a
                  href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}">{$attachment.name}</a>
              </h3>
              <p>{$attachment.description}</p> <a
                href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}"><i class="fas fa-book fa-2x"></i>
              {l s='Download' d='Shop.Theme.Actions'} ({$attachment.file_size_formatted})
              </a>
            </div>
            {/foreach}
          </div>
        </div>
        {/if}
        <!--          Accessoires-->
        {if $accessories}
        <div class="card accessoires">
          <h2 id="accessoires">Accessoires pour : {$product.name}</h2>
          <div class=" cardlist l4 m3 s1">
            {foreach from=$accessories item="product_accessory"}
            {block name='product_miniature'}
            {include file='catalog/_partials/miniatures/product.tpl' product=$product_accessory}
            {/block}
            {/foreach}
          </div>
        </div>
        {/if}
        <!--          Extras-->
        <!--
           {foreach from=$product.extraContent item=extra key=extraKey}
              <div class="card"><h2 id="{$extra.title}">{$extra.title}</h2>
          </div>
          {/foreach}
-->
{block name='extra'}
{hook h='displayProductTabContent' product=$product category=$category}
{/block}
      </div>
    </div>
    {/block}






    {block name='product_images_modal'}
    {include file='catalog/_partials/product-images-modal.tpl'}
    {/block}

    {block name='page_footer_container'}
    <footer class="page-footer">
      {block name='page_footer'}
      <!-- Footer content -->
      {/block}
    </footer>
    {/block}
  </section>

  {/block}
